/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.pool;

import com.highcharts.export.pool.ObjectFactory;
import com.highcharts.export.server.Server;
import com.highcharts.export.server.ServerState;
import com.highcharts.export.util.TempDir;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class ServerObjectFactory
implements ObjectFactory<Server> {
    public String exec;
    public String script;
    private String host;
    private int basePort;
    private int readTimeout;
    private int poolSize;
    private int connectTimeout;
    private int maxTimeout;
    private static TreeMap<Integer, PortStatus> portUsage = new TreeMap();
    protected static Logger logger = Logger.getLogger((String)"pool");

    @Override
    public Server create() {
        logger.debug((Object)("in makeObject, " + this.exec + ", " + this.script + ", " + this.host));
        Integer port = this.getAvailablePort();
        if (this.script.isEmpty()) {
            this.script = TempDir.getPhantomJsDir().toAbsolutePath().toString() + "/highcharts-convert.js";
        }
        Server server = new Server(this.exec, this.script, this.host, port, this.connectTimeout, this.readTimeout, this.maxTimeout);
        portUsage.put(port, PortStatus.BUSY);
        return server;
    }

    @Override
    public boolean validate(Server server) {
        boolean isValid = false;
        try {
            if (server.getState() != ServerState.IDLE) {
                logger.debug((Object)"server didn't pass validation");
                return false;
            }
            String result = server.request("{\"status\":\"isok\"}");
            if (result.indexOf("OK") > -1) {
                isValid = true;
                logger.debug((Object)"server passed validation");
            } else {
                logger.debug((Object)"server didn't pass validation");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while validating object in Pool: " + e.getMessage()));
        }
        return isValid;
    }

    @Override
    public void destroy(Server server) {
        ServerObjectFactory.releasePort(server.getPort());
        server.cleanup();
    }

    @Override
    public void activate(Server server) {
        server.setState(ServerState.ACTIVE);
    }

    @Override
    public void passivate(Server server) {
        server.setState(ServerState.IDLE);
    }

    public static void releasePort(Integer port) {
        logger.debug((Object)("Releasing port " + port));
        portUsage.put(port, PortStatus.FREE);
    }

    public Integer getAvailablePort() {
        for (int port = this.basePort; port < this.basePort + this.poolSize; ++port) {
            if (portUsage.containsKey(port)) {
                if (portUsage.get(port) != PortStatus.FREE) continue;
                return port;
            }
            return port;
        }
        logger.debug((Object)("Nothing free in Portusage " + portUsage.toString()));
        return portUsage.lastKey() + 1;
    }

    public String getExec() {
        return this.exec;
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getBasePort() {
        return this.basePort;
    }

    public void setBasePort(int basePort) {
        this.basePort = basePort;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(int maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    @PostConstruct
    public void afterBeanInit() {
        String[] filenames;
        URL u = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader jarLoader = new URLClassLoader(new URL[]{u}, Thread.currentThread().getContextClassLoader());
        for (String filename : filenames = new String[]{"highcharts-convert.js", "highcharts.js", "highstock.js", "jquery.1.9.1.min.js", "map.js", "highcharts-more.js", "data.js", "drilldown.js", "funnel.js", "heatmap.js", "highcharts-3d.js", "no-data-to-display.js", "solid-gauge.js", "broken-axis.js"}) {
            ClassPathResource resource = new ClassPathResource("phantomjs/" + filename, (ClassLoader)jarLoader);
            if (resource.exists()) {
                Path path = Paths.get(TempDir.getPhantomJsDir().toString(), filename);
                try {
                    File file = Files.createFile(path, new FileAttribute[0]).toFile();
                    file.deleteOnExit();
                    InputStream in = resource.getInputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(file));
                }
                catch (IOException ioex) {
                    logger.error((Object)("Error while setting up phantomjs environment: " + ioex.getMessage()));
                }
                continue;
            }
            logger.debug((Object)("Copy javascript file to temp folder, resource doesn't exist: " + filename));
        }
    }

    private static enum PortStatus {
        BUSY,
        FREE;

    }
}

