/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Hex;
import org.owasp.esapi.crypto.CipherSpec;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.CryptoHelper;
import org.owasp.esapi.crypto.KeyDerivationFunction;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.crypto.SecurityProviderLoader;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;

public final class JavaEncryptor
implements Encryptor {
    private static volatile Encryptor singletonInstance;
    private static boolean initialized;
    private static SecretKeySpec secretKeySpec;
    private static String encryptAlgorithm;
    private static String encoding;
    private static int encryptionKeyLength;
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static String signatureAlgorithm;
    private static String randomAlgorithm;
    private static int signatureKeyLength;
    private static String hashAlgorithm;
    private static int hashIterations;
    private static Logger logger;
    private static int encryptCounter;
    private static int decryptCounter;
    private static final int logEveryNthUse = 25;
    private static final String DECRYPTION_FAILED = "Decryption failed; see logs for details.";
    private static int N_SECS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encryptor getInstance() throws EncryptionException {
        if (singletonInstance != null) return singletonInstance;
        Class<JavaEncryptor> clazz = JavaEncryptor.class;
        synchronized (JavaEncryptor.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new JavaEncryptor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Generating a new secret master key");
        if (args.length == 1 && args[0].equalsIgnoreCase("-print")) {
            System.out.println("AVAILABLE ALGORITHMS");
            Provider[] providers = Security.getProviders();
            TreeMap<String, String> tm = new TreeMap<String, String>();
            for (int i = 0; i != providers.length; ++i) {
                System.out.println("===== Provider " + i + ":" + providers[i].getName() + " ======");
                for (String string : providers[i].keySet()) {
                    String value = providers[i].getProperty(string);
                    tm.put(string, value);
                    System.out.println("\t\t   " + string + " -> " + value);
                }
            }
            Set keyValueSet = tm.entrySet();
            for (Map.Entry entry : keyValueSet) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                System.out.println("   " + key + " -> " + value);
            }
        } else {
            System.out.println("\tuse '-print' to also show available crypto algorithms from all the security providers");
        }
        encryptAlgorithm = ESAPI.securityConfiguration().getEncryptionAlgorithm();
        encryptionKeyLength = ESAPI.securityConfiguration().getEncryptionKeyLength();
        randomAlgorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        SecureRandom random = SecureRandom.getInstance(randomAlgorithm);
        SecretKey secretKey = CryptoHelper.generateSecretKey(encryptAlgorithm, encryptionKeyLength);
        byte[] raw = secretKey.getEncoded();
        byte[] salt = new byte[20];
        random.nextBytes(salt);
        String string = System.getProperty("line.separator", "\n");
        System.out.println(string + "Copy and paste these lines into your ESAPI.properties" + string);
        System.out.println("#==============================================================");
        System.out.println("Encryptor.MasterKey=" + ESAPI.encoder().encodeForBase64(raw, false));
        System.out.println("Encryptor.MasterSalt=" + ESAPI.encoder().encodeForBase64(salt, false));
        System.out.println("#==============================================================" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaEncryptor() throws EncryptionException {
        byte[] salt = ESAPI.securityConfiguration().getMasterSalt();
        byte[] skey = ESAPI.securityConfiguration().getMasterKey();
        assert (salt != null) : "Can't obtain master salt, Encryptor.MasterSalt";
        assert (salt.length >= 16) : "Encryptor.MasterSalt must be at least 16 bytes. Length is: " + salt.length + " bytes.";
        assert (skey != null) : "Can't obtain master key, Encryptor.MasterKey";
        assert (skey.length >= 7) : "Encryptor.MasterKey must be at least 7 bytes. Length is: " + skey.length + " bytes.";
        Class<JavaEncryptor> clazz = JavaEncryptor.class;
        synchronized (JavaEncryptor.class) {
            if (!initialized) {
                secretKeySpec = new SecretKeySpec(skey, encryptAlgorithm);
                try {
                    SecureRandom prng = SecureRandom.getInstance(randomAlgorithm);
                    byte[] seed = this.hash(new String(skey, encoding), new String(salt, encoding)).getBytes(encoding);
                    prng.setSeed(seed);
                    JavaEncryptor.initKeyPair(prng);
                }
                catch (Exception e) {
                    throw new EncryptionException("Encryption failure", "Error creating Encryptor", e);
                }
                initialized = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String hash(String plaintext, String salt) throws EncryptionException {
        return this.hash(plaintext, salt, hashIterations);
    }

    public String hash(String plaintext, String salt, int iterations) throws EncryptionException {
        byte[] bytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            digest.reset();
            digest.update(ESAPI.securityConfiguration().getMasterSalt());
            digest.update(salt.getBytes(encoding));
            digest.update(plaintext.getBytes(encoding));
            bytes = digest.digest();
            for (int i = 0; i < iterations; ++i) {
                digest.reset();
                bytes = digest.digest(bytes);
            }
            String encoded = ESAPI.encoder().encodeForBase64(bytes, false);
            return encoded;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Internal error", "Can't find hash algorithm " + hashAlgorithm, e);
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncryptionException("Internal error", "Can't find encoding for " + encoding, ex);
        }
    }

    public CipherText encrypt(PlainText plaintext) throws EncryptionException {
        return this.encrypt(secretKeySpec, plaintext);
    }

    public CipherText encrypt(SecretKey key, PlainText plain) throws EncryptionException {
        if (key == null) {
            throw new IllegalArgumentException("(Master) encryption key arg may not be null. Is Encryptor.MasterKey set?");
        }
        if (plain == null) {
            throw new IllegalArgumentException("PlainText may arg not be null");
        }
        byte[] plaintext = plain.asBytes();
        boolean overwritePlaintext = ESAPI.securityConfiguration().overwritePlainText();
        boolean success = false;
        String xform = null;
        int keySize = key.getEncoded().length * 8;
        try {
            String skeyAlg;
            xform = ESAPI.securityConfiguration().getCipherTransformation();
            String[] parts = xform.split("/");
            assert (parts.length == 3) : "Malformed cipher transformation: " + xform;
            String cipherMode = parts[1];
            if (!CryptoHelper.isAllowedCipherMode(cipherMode)) {
                throw new EncryptionException("Encryption failure: invalid cipher mode ( " + cipherMode + ") for encryption", "Encryption failure: Cipher transformation " + xform + " specifies invalid " + "cipher mode " + cipherMode);
            }
            Cipher encrypter = Cipher.getInstance(xform);
            String cipherAlg = encrypter.getAlgorithm();
            int keyLen = ESAPI.securityConfiguration().getEncryptionKeyLength();
            if (keySize != keyLen) {
                logger.warning(Logger.SECURITY_FAILURE, "Encryption key length mismatch. ESAPI.EncryptionKeyLength is " + keyLen + " bits, but length of actual encryption key is " + keySize + " bits.  Did you remember to regenerate your master key (if that is what you are using)???");
            }
            if (keySize < keyLen) {
                logger.warning(Logger.SECURITY_FAILURE, "Actual key size of " + keySize + " bits SMALLER THAN specified " + "encryption key length (ESAPI.EncryptionKeyLength) of " + keyLen + " bits with cipher algorithm " + cipherAlg);
            }
            if (keySize < 112) {
                logger.warning(Logger.SECURITY_FAILURE, "Potentially unsecure encryption. Key size of " + keySize + "bits " + "not sufficiently long for " + cipherAlg + ". Should use appropriate algorithm with key size " + "of *at least* 112 bits except when required by legacy apps. See NIST Special Pub 800-57.");
            }
            if (!cipherAlg.startsWith((skeyAlg = key.getAlgorithm()) + "/") && !cipherAlg.equals(skeyAlg)) {
                logger.warning(Logger.SECURITY_FAILURE, "Encryption mismatch between cipher algorithm (" + cipherAlg + ") and SecretKey algorithm (" + skeyAlg + "). Cipher will use algorithm " + cipherAlg);
            }
            byte[] ivBytes = null;
            CipherSpec cipherSpec = new CipherSpec(encrypter, keySize);
            boolean preferredCipherMode = CryptoHelper.isCombinedCipherMode(cipherMode);
            SecretKey encKey = null;
            encKey = preferredCipherMode ? key : this.computeDerivedKey(20130830, this.getDefaultPRF(), key, keySize, "encryption");
            if (cipherSpec.requiresIV()) {
                String ivType = ESAPI.securityConfiguration().getIVType();
                IvParameterSpec ivSpec = null;
                if (ivType.equalsIgnoreCase("random")) {
                    ivBytes = ESAPI.randomizer().getRandomBytes(encrypter.getBlockSize());
                } else if (ivType.equalsIgnoreCase("fixed")) {
                    String fixedIVAsHex = ESAPI.securityConfiguration().getFixedIV();
                    ivBytes = Hex.decode(fixedIVAsHex);
                } else {
                    throw new ConfigurationException("Property Encryptor.ChooseIVMethod must be set to 'random' or 'fixed'");
                }
                ivSpec = new IvParameterSpec(ivBytes);
                cipherSpec.setIV(ivBytes);
                encrypter.init(1, (Key)encKey, ivSpec);
            } else {
                encrypter.init(1, encKey);
            }
            logger.debug(Logger.EVENT_SUCCESS, "Encrypting with " + cipherSpec);
            byte[] raw = encrypter.doFinal(plaintext);
            CipherText ciphertext = new CipherText(cipherSpec, raw);
            if (!preferredCipherMode) {
                SecretKey authKey = this.computeDerivedKey(20130830, this.getDefaultPRF(), key, keySize, "authenticity");
                ciphertext.computeAndStoreMAC(authKey);
            }
            logger.debug(Logger.EVENT_SUCCESS, "JavaEncryptor.encrypt(SecretKey,byte[],boolean,boolean) -- success!");
            success = true;
            CipherText cipherText = ciphertext;
            return cipherText;
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure: Invalid key exception.", "Requested key size: " + keySize + "bits greater than 128 bits. Must install unlimited strength crypto extension from Sun: " + ike.getMessage(), ike);
        }
        catch (ConfigurationException cex) {
            throw new EncryptionException("Encryption failure: Configuration error. Details in log.", "Key size mismatch or unsupported IV method. Check encryption key size vs. ESAPI.EncryptionKeyLength or Encryptor.ChooseIVMethod property.", cex);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException("Encryption failure (invalid IV)", "Encryption problem: Invalid IV spec: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("Encryption failure (no padding used; invalid input size)", "Encryption problem: Invalid input size without padding (" + xform + "). " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException("Encryption failure", "[Note: Should NEVER happen in encryption mode.] Encryption problem: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Encryption failure (unavailable cipher requested)", "Encryption problem: specified algorithm in cipher xform " + xform + " not available: " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Encryption failure (unavailable padding scheme requested)", "Encryption problem: specified padding scheme in cipher xform " + xform + " not available: " + e.getMessage(), e);
        }
        finally {
            if (success && overwritePlaintext) {
                plain.overwrite();
            }
        }
    }

    public PlainText decrypt(CipherText ciphertext) throws EncryptionException {
        return this.decrypt(secretKeySpec, ciphertext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlainText decrypt(SecretKey key, CipherText ciphertext) throws EncryptionException, IllegalArgumentException {
        long start = System.nanoTime();
        if (key == null) {
            throw new IllegalArgumentException("SecretKey arg may not be null");
        }
        if (ciphertext == null) {
            throw new IllegalArgumentException("Ciphertext may arg not be null");
        }
        if (!CryptoHelper.isAllowedCipherMode(ciphertext.getCipherMode())) {
            throw new EncryptionException(DECRYPTION_FAILED, "Invalid cipher mode " + ciphertext.getCipherMode() + " not permitted for decryption or encryption operations.");
        }
        logger.debug(Logger.EVENT_SUCCESS, "Args valid for JavaEncryptor.decrypt(SecretKey,CipherText): " + ciphertext);
        PlainText plaintext = null;
        boolean caughtException = false;
        int progressMark = 0;
        try {
            try {
                boolean valid = CryptoHelper.isCipherTextMACvalid(key, ciphertext);
                if (!valid) {
                    try {
                        this.handleDecryption(key, ciphertext);
                        throw new EncryptionException(DECRYPTION_FAILED, "Decryption failed because MAC invalid for " + ciphertext);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw new EncryptionException(DECRYPTION_FAILED, "Decryption failed because MAC invalid for " + ciphertext);
                }
                ++progressMark;
                plaintext = this.handleDecryption(key, ciphertext);
                ++progressMark;
            }
            catch (EncryptionException ex) {
                caughtException = true;
                String logMsg = null;
                switch (progressMark) {
                    case 1: {
                        logMsg = "Decryption failed because MAC invalid. See logged exception for details.";
                        break;
                    }
                    case 2: {
                        logMsg = "Decryption failed because handleDecryption() failed. See logged exception for details.";
                        break;
                    }
                    default: {
                        logMsg = "Programming error: unexpected progress mark == " + progressMark;
                    }
                }
                logger.error(Logger.SECURITY_FAILURE, logMsg);
                throw ex;
            }
            Object var11_11 = null;
            if (!caughtException) return plaintext;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!caughtException) throw throwable;
            long now = System.nanoTime();
            long elapsed = now - start;
            long NANOSECS_IN_SEC = 1000000000L;
            long nSecs = (long)N_SECS * 1000000000L;
            if (elapsed >= nSecs) throw throwable;
            long extraSleep = nSecs - elapsed;
            long millis = extraSleep / 1000000L;
            long nanos = extraSleep - millis * 1000000L;
            if (!$assertionsDisabled) {
                if (nanos < 0L) throw new AssertionError((Object)("Nanosecs out of bounds; nanos = " + nanos));
                if (nanos > Integer.MAX_VALUE) {
                    throw new AssertionError((Object)("Nanosecs out of bounds; nanos = " + nanos));
                }
            }
            try {
                Thread.sleep(millis, (int)nanos);
                throw throwable;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            throw throwable;
        }
        long now = System.nanoTime();
        long elapsed = now - start;
        long NANOSECS_IN_SEC = 1000000000L;
        long nSecs = (long)N_SECS * 1000000000L;
        if (elapsed >= nSecs) return plaintext;
        long extraSleep = nSecs - elapsed;
        long millis = extraSleep / 1000000L;
        long nanos = extraSleep - millis * 1000000L;
        if (!$assertionsDisabled) {
            if (nanos < 0L) throw new AssertionError((Object)("Nanosecs out of bounds; nanos = " + nanos));
            if (nanos > Integer.MAX_VALUE) {
                throw new AssertionError((Object)("Nanosecs out of bounds; nanos = " + nanos));
            }
        }
        try {}
        catch (InterruptedException ex) {}
        Thread.sleep(millis, (int)nanos);
        return plaintext;
    }

    private PlainText handleDecryption(SecretKey key, CipherText ciphertext) throws EncryptionException {
        int keySize = 0;
        try {
            Cipher decrypter = Cipher.getInstance(ciphertext.getCipherTransformation());
            keySize = key.getEncoded().length * 8;
            boolean preferredCipherMode = CryptoHelper.isCombinedCipherMode(ciphertext.getCipherMode());
            SecretKey encKey = null;
            encKey = preferredCipherMode ? key : this.computeDerivedKey(ciphertext.getKDFVersion(), ciphertext.getKDF_PRF(), key, keySize, "encryption");
            if (ciphertext.requiresIV()) {
                decrypter.init(2, (Key)encKey, new IvParameterSpec(ciphertext.getIV()));
            } else {
                decrypter.init(2, encKey);
            }
            byte[] output = decrypter.doFinal(ciphertext.getRawCipherText());
            return new PlainText(output);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException(DECRYPTION_FAILED, "Must install JCE Unlimited Strength Jurisdiction Policy Files from Sun", ike);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Invalid algorithm for available JCE providers - " + ciphertext.getCipherTransformation() + ": " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Invalid padding scheme (" + ciphertext.getPaddingScheme() + ") for cipher transformation " + ciphertext.getCipherTransformation() + ": " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            SecretKey authKey;
            try {
                authKey = this.computeDerivedKey(ciphertext.getKDFVersion(), ciphertext.getKDF_PRF(), key, keySize, "authenticity");
            }
            catch (Exception e1) {
                throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem -- failed to compute derived key for authenticity: " + e1.getMessage(), e1);
            }
            boolean success = ciphertext.validateMAC(authKey);
            if (success) {
                throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: " + e.getMessage(), e);
            }
            throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: WARNING: Adversary may have tampered with CipherText object orCipherText object mangled in transit: " + e.getMessage(), e);
        }
    }

    public String sign(String data) throws EncryptionException {
        try {
            Signature signer = Signature.getInstance(signatureAlgorithm);
            signer.initSign(privateKey);
            signer.update(data.getBytes(encoding));
            byte[] bytes = signer.sign();
            return ESAPI.encoder().encodeForBase64(bytes, false);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure", "Must install unlimited strength crypto extension from Sun", ike);
        }
        catch (Exception e) {
            throw new EncryptionException("Signature failure", "Can't find signature algorithm " + signatureAlgorithm, e);
        }
    }

    public boolean verifySignature(String signature, String data) {
        try {
            byte[] bytes = ESAPI.encoder().decodeFromBase64(signature);
            Signature signer = Signature.getInstance(signatureAlgorithm);
            signer.initVerify(publicKey);
            signer.update(data.getBytes(encoding));
            return signer.verify(bytes);
        }
        catch (Exception e) {
            new EncryptionException("Invalid signature", "Problem verifying signature: " + e.getMessage(), e);
            return false;
        }
    }

    public String seal(String data, long expiration) throws IntegrityException {
        if (data == null) {
            throw new IllegalArgumentException("Data to be sealed may not be null.");
        }
        try {
            String b64data = null;
            try {
                b64data = ESAPI.encoder().encodeForBase64(data.getBytes("UTF-8"), false);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            String nonce = ESAPI.randomizer().getRandomString(10, EncoderConstants.CHAR_ALPHANUMERICS);
            String plaintext = expiration + ":" + nonce + ":" + b64data;
            String sig = this.sign(plaintext);
            CipherText ciphertext = this.encrypt(new PlainText(plaintext + ":" + sig));
            String sealedData = ESAPI.encoder().encodeForBase64(ciphertext.asPortableSerializedByteArray(), false);
            return sealedData;
        }
        catch (EncryptionException e) {
            throw new IntegrityException(e.getUserMessage(), e.getLogMessage(), e);
        }
    }

    public String unseal(String seal) throws EncryptionException {
        PlainText plaintext = null;
        try {
            long expiration;
            byte[] encryptedBytes = ESAPI.encoder().decodeFromBase64(seal);
            CipherText cipherText = null;
            try {
                cipherText = CipherText.fromPortableSerializedBytes(encryptedBytes);
            }
            catch (AssertionError e) {
                throw new EncryptionException("Invalid seal", "Seal passed garbarge data resulting in AssertionError: " + e);
            }
            plaintext = this.decrypt(cipherText);
            String[] parts = plaintext.toString().split(":");
            if (parts.length != 4) {
                throw new EncryptionException("Invalid seal", "Seal was not formatted properly.");
            }
            String timestring = parts[0];
            long now = new Date().getTime();
            if (now > (expiration = Long.parseLong(timestring))) {
                throw new EncryptionException("Invalid seal", "Seal expiration date of " + new Date(expiration) + " has past.");
            }
            String nonce = parts[1];
            String b64data = parts[2];
            String sig = parts[3];
            if (!this.verifySignature(sig, timestring + ":" + nonce + ":" + b64data)) {
                throw new EncryptionException("Invalid seal", "Seal integrity check failed");
            }
            return new String(ESAPI.encoder().decodeFromBase64(b64data), "UTF-8");
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Invalid seal", "Invalid seal:" + e.getMessage(), e);
        }
    }

    public boolean verifySeal(String seal) {
        try {
            this.unseal(seal);
            return true;
        }
        catch (EncryptionException e) {
            return false;
        }
    }

    public long getTimeStamp() {
        return new Date().getTime();
    }

    public long getRelativeTimeStamp(long offset) {
        return new Date().getTime() + offset;
    }

    private void logWarning(String where, String msg) {
        int counter = 0;
        if (where.equals("encrypt")) {
            counter = encryptCounter++;
            where = "JavaEncryptor.encrypt(): [count=" + counter + "]";
        } else if (where.equals("decrypt")) {
            counter = decryptCounter++;
            where = "JavaEncryptor.decrypt(): [count=" + counter + "]";
        } else {
            where = "JavaEncryptor: Unknown method: ";
        }
        if (counter % 25 == 0) {
            logger.warning(Logger.SECURITY_FAILURE, where + msg);
        }
    }

    private KeyDerivationFunction.PRF_ALGORITHMS getPRF(String name) {
        String prfName = null;
        prfName = name == null ? ESAPI.securityConfiguration().getKDFPseudoRandomFunction() : name;
        KeyDerivationFunction.PRF_ALGORITHMS prf = KeyDerivationFunction.convertNameToPRF(prfName);
        return prf;
    }

    private KeyDerivationFunction.PRF_ALGORITHMS getDefaultPRF() {
        String prfName = ESAPI.securityConfiguration().getKDFPseudoRandomFunction();
        return this.getPRF(prfName);
    }

    private SecretKey computeDerivedKey(int kdfVersion, KeyDerivationFunction.PRF_ALGORITHMS prf, SecretKey kdk, int keySize, String purpose) throws NoSuchAlgorithmException, InvalidKeyException, EncryptionException {
        assert (prf != null) : "Pseudo Random Function for KDF cannot be null";
        assert (kdk != null) : "Key derivation key cannot be null.";
        assert (keySize >= 56) : "Key has size of " + keySize + ", which is less than minimum of 56-bits.";
        assert (keySize % 8 == 0) : "Key size (" + keySize + ") must be a even multiple of 8-bits.";
        assert (purpose != null) : "Purpose cannot be null. Should be 'encryption' or 'authenticity'.";
        assert (purpose.equals("encryption") || purpose.equals("authenticity")) : "Purpose must be \"encryption\" or \"authenticity\".";
        KeyDerivationFunction kdf = new KeyDerivationFunction(prf);
        if (kdfVersion != 0) {
            kdf.setVersion(kdfVersion);
        }
        return kdf.computeDerivedKey(kdk, keySize, purpose);
    }

    private static void setupAlgorithms() {
        encryptAlgorithm = ESAPI.securityConfiguration().getEncryptionAlgorithm();
        signatureAlgorithm = ESAPI.securityConfiguration().getDigitalSignatureAlgorithm();
        randomAlgorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        hashAlgorithm = ESAPI.securityConfiguration().getHashAlgorithm();
        hashIterations = ESAPI.securityConfiguration().getHashIterations();
        encoding = ESAPI.securityConfiguration().getCharacterEncoding();
        encryptionKeyLength = ESAPI.securityConfiguration().getEncryptionKeyLength();
        signatureKeyLength = ESAPI.securityConfiguration().getDigitalSignatureKeyLength();
    }

    private static void initKeyPair(SecureRandom prng) throws NoSuchAlgorithmException {
        String sigAlg = signatureAlgorithm.toLowerCase();
        if (sigAlg.endsWith("withdsa")) {
            sigAlg = "DSA";
        } else if (sigAlg.endsWith("withrsa")) {
            sigAlg = "RSA";
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(sigAlg);
        keyGen.initialize(signatureKeyLength, prng);
        KeyPair pair = keyGen.generateKeyPair();
        privateKey = pair.getPrivate();
        publicKey = pair.getPublic();
    }

    static {
        initialized = false;
        secretKeySpec = null;
        encryptAlgorithm = "AES";
        encoding = "UTF-8";
        encryptionKeyLength = 128;
        privateKey = null;
        publicKey = null;
        signatureAlgorithm = "SHA1withDSA";
        randomAlgorithm = "SHA1PRNG";
        signatureKeyLength = 1024;
        hashAlgorithm = "SHA-512";
        hashIterations = 1024;
        logger = ESAPI.getLogger("JavaEncryptor");
        encryptCounter = 0;
        decryptCounter = 0;
        N_SECS = 2;
        try {
            SecurityProviderLoader.loadESAPIPreferredJCEProvider();
        }
        catch (NoSuchProviderException ex) {
            logger.fatal(Logger.SECURITY_FAILURE, "JavaEncryptor failed to load preferred JCE provider.", ex);
            throw new ExceptionInInitializerError(ex);
        }
        JavaEncryptor.setupAlgorithms();
    }
}

